<%@ Language="VBScript" %>
<% Option Explicit %>
<!-- #include file="Config.asp" -->
<%
	' Copyright 2005 by Logical Expressions, Inc. All rights reserved.
	' Visit www.LogicalExpressions.com for more information.
	' You may freely modify and use the code within this file for your own applications.
	' However, You must leave this notice intact if you distribute the file to others.

	' Redirect to login form if no user name has been written to the session.
	If Len(Session("Login.UserName")) = 0 Then
		Response.Redirect("Login.asp")
	End If

	Dim strServerFilePath, strMIMEContentType, strClientFileName, strFileData
	Dim objFS, objStream
	Dim dtTransferStart

	' Get the name of the requested file and assemble the source path:
	strClientFileName = Request.QueryString("File")
	strServerFilePath = conDownloadFolder & "\" & strClientFileName
	' The example assumes all files are text files. You could look at the 
	' file extension instead and set the MIME content type accordingly.
	strMIMEContentType = "text/plain"

	' Record the transfer start time:
   dtTransferStart = Now()

	' Retrieve the file contents.
	' NOTE: You may need to turn off script blocking in your anti-virus product before
	' you attempt to run this example on your development system. Script blocking
	' has been known to prevent the FileSystemObject from functioning properly.
	Set objFS = Server.CreateObject("Scripting.FileSystemObject")
	' Open the text file with read access:
	Set objStream = objFS.OpenTextFile(strServerFilePath, 1)
	' It would be better to read line-by-line and write to the browser incrementally 
	' if your files are large, but the text files in this example are small enough 
	' to grab in one shot with the ReadAll method.
	strFileData = objStream.ReadAll()
	Call objStream.Close()
	Set objStream = Nothing
	Set objFS = Nothing
	
	' Different versions of IIS have different defaults for buffering output.
	' You don't need or want buffering for the transfer (particularly if you are 
	' looping through the file line-by-line), so make sure it is off.
	If Response.Buffer Then
		Call Response.Clear
		Response.Buffer = False
	End If
	' Expire the downloaded data and request no caching as an extra security precaution.
	Response.Expires = -100
	Response.CacheControl = "no-cache"
	Response.ContentType = strMIMEContentType
	Call Response.AddHeader("Pragma", "no-cache")
	' The Content-Disposition header triggers the browser to display the Save As dialog:
	Call Response.AddHeader("Content-Disposition", "attachment; filename=" & strClientFileName)
	' Transfer the file to the browser using default code page.
	Call Response.Write(strFileData)
	
	Session("HttpDownload.TransferSeconds") = DateDiff("s", dtTransferStart, Now())
%>